/*!
 * @file       main.h
 *
 * @brief      Header for main.c module
 *
 * @version    V1.0.0
 *
 * @date       2022-05-25
 *
 */
#ifndef __MAIN_H
#define __MAIN_H

#ifdef __cplusplus
  extern "C" {
#endif

#include "apm32f4xx.h"

#if defined (APM32F407_MINI)

#elif defined (APM32F407_ELE_HUETB)

#elif defined (APM32F407_EVAL)

#define APM_BOARD_COMInit    APM_EVAL_COMInit
#define APM_BOARD_LEDInit    APM_EVAL_LEDInit
#define APM_BOARD_LEDOn      APM_EVAL_LEDOn
#define APM_BOARD_LEDOff     APM_EVAL_LEDOff
#define APM_BOARD_LEDToggle  APM_EVAL_LEDToggle
#define APM_BOARD_PBInit     APM_EVAL_PBInit
#define APM_BOARD_PBGetState APM_EVAL_PBGetState

#else
#error "Please select first the APM32  board to be used (in board.h)"
#endif

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H */
